/*
 * Decompiled with CFR 0.152.
 */
package glodblock.com.github.items;

import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import flaxbeard.immersivepetroleum.api.crafting.PumpjackHandler;
import glodblock.com.github.config.ConfigLoader;
import glodblock.com.github.handlers.GetItemFromBlock;
import glodblock.com.github.handlers.HandlerIEVein;
import glodblock.com.github.handlers.HandlerOilVein;
import glodblock.com.github.handlers.HandlerOreData;
import glodblock.com.github.items.ItemBase;
import glodblock.com.github.network.ScannerPacket;
import glodblock.com.github.orevisualdetector.Main;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.oredict.OreDictionary;

public class Scanner
extends ItemBase {
    private static final int MODES = 3;

    public Scanner(String name) {
        super(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World aWorld, @Nonnull EntityPlayer aPlayer, @Nonnull EnumHand hand) {
        if (!aWorld.field_72995_K) {
            if (aPlayer.func_70093_af()) {
                this.nextMode(aPlayer.func_184586_b(hand));
                aPlayer.func_145747_a((ITextComponent)new TextComponentTranslation("scanner.mode." + this.getMode(aPlayer.func_184586_b(hand)), new Object[0]));
                return new ActionResult(EnumActionResult.SUCCESS, (Object)aPlayer.func_184586_b(hand));
            }
            int cX = (int)aPlayer.field_70165_t >> 4;
            int cZ = (int)aPlayer.field_70161_v >> 4;
            int size = ConfigLoader.ScannerSize + 1;
            ArrayList<Chunk> chunks = new ArrayList<Chunk>();
            for (int i = -size; i <= size; ++i) {
                for (int j = -size; j <= size; ++j) {
                    if (i == -size || i == size || j == -size || j == size) continue;
                    chunks.add(aWorld.func_72964_e(cX + i, cZ + j));
                }
            }
            --size;
            int scannerMode = this.getMode(aPlayer.func_184586_b(hand));
            if (scannerMode < 0) {
                return new ActionResult(EnumActionResult.FAIL, (Object)aPlayer.func_184586_b(hand));
            }
            ScannerPacket packet = new ScannerPacket(cX, cZ, (int)aPlayer.field_70165_t, (int)aPlayer.field_70161_v, size, scannerMode);
            boolean sus = false;
            if (scannerMode == 0) {
                this.runInWorldOreScan(chunks, aWorld, packet);
                sus = true;
            } else if (scannerMode == 1) {
                if (Loader.isModLoaded((String)"immersiveengineering")) {
                    this.runIEVeinScan(chunks, aWorld, packet);
                    sus = true;
                } else {
                    aPlayer.func_145747_a((ITextComponent)new TextComponentTranslation("scanner.error.ie", new Object[0]));
                }
            } else if (scannerMode == 2) {
                if (Loader.isModLoaded((String)"immersivepetroleum")) {
                    this.runIPReservoirScan(chunks, aWorld, packet);
                    sus = true;
                } else {
                    aPlayer.func_145747_a((ITextComponent)new TextComponentTranslation("scanner.error.ip", new Object[0]));
                }
            }
            if (!sus) return new ActionResult(EnumActionResult.FAIL, (Object)aPlayer.func_184586_b(hand));
            Main.proxy.netHandler.sendTo((IMessage)packet, (EntityPlayerMP)aPlayer);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)aPlayer.func_184586_b(hand));
        } else {
            int scannerMode;
            if (aPlayer.func_70093_af() || (scannerMode = this.getMode(aPlayer.func_184586_b(hand))) != 0) return new ActionResult(EnumActionResult.SUCCESS, (Object)aPlayer.func_184586_b(hand));
            int cX = (int)aPlayer.field_70165_t >> 4;
            int cZ = (int)aPlayer.field_70161_v >> 4;
            int size = ConfigLoader.ScannerSize + 1;
            ArrayList<Chunk> chunks = new ArrayList<Chunk>();
            for (int i = -size; i <= size; ++i) {
                for (int j = -size; j <= size; ++j) {
                    if (i == -size || i == size || j == -size || j == size) continue;
                    chunks.add(aWorld.func_72964_e(cX + i, cZ + j));
                }
            }
            ScannerPacket packet = new ScannerPacket(cX, cZ, (int)aPlayer.field_70165_t, (int)aPlayer.field_70161_v, --size, scannerMode);
            this.runInWorldOreScan(chunks, aWorld, packet);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)aPlayer.func_184586_b(hand));
    }

    public int getMode(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof Scanner) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag != null) {
                if (tag.func_74764_b("mode")) {
                    return tag.func_74771_c("mode");
                }
                tag.func_74774_a("mode", (byte)0);
            } else {
                tag = new NBTTagCompound();
                tag.func_74774_a("mode", (byte)0);
                stack.func_77982_d(tag);
            }
            return 0;
        }
        return -1;
    }

    public void nextMode(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof Scanner) {
            int mode = (this.getMode(stack) + 1) % 3;
            NBTTagCompound tag = stack.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            tag.func_74774_a("mode", (byte)mode);
            stack.func_77982_d(tag);
        }
    }

    private void runInWorldOreScan(List<Chunk> area, World world, ScannerPacket packet) {
        for (Chunk c : area) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    int ySize = c.func_76611_b(x, z);
                    for (int y = 1; y < ySize; ++y) {
                        ItemStack tItem = GetItemFromBlock.getItemStackFromState(c.func_186032_a(x, y, z), world);
                        if (tItem.func_190926_b()) continue;
                        for (int ID : OreDictionary.getOreIDs((ItemStack)tItem)) {
                            String tOreDictName = OreDictionary.getOreName((int)ID);
                            if (!HandlerOreData.mOreDictMap.containsKey(tOreDictName)) continue;
                            packet.addBlock(c.func_76632_l().field_77276_a * 16 + x, y, c.func_76632_l().field_77275_b * 16 + z, HandlerOreData.mNameToIDMap.get(tOreDictName));
                            ScannerPacket.addOre(packet, HandlerOreData.mNameToIDMap.get(tOreDictName));
                            HandlerOreData.mIDToDisplayNameMap.put(HandlerOreData.mNameToIDMap.get(tOreDictName), tItem.func_82833_r());
                        }
                        if (tItem.func_77973_b().getRegistryName() == null) continue;
                        String unName = tItem.func_77973_b().getRegistryName().toString();
                        String wildName = tItem.func_77973_b().getRegistryName().toString() + ":*";
                        if (Items.field_151008_G.getDamage(tItem) != 0) {
                            unName = unName + ":" + Items.field_151008_G.getDamage(tItem);
                        }
                        if (HandlerOreData.mUnlocalizedMap.containsKey(unName)) {
                            packet.addBlock(c.func_76632_l().field_77276_a * 16 + x, y, c.func_76632_l().field_77275_b * 16 + z, HandlerOreData.mNameToIDMap.get(unName));
                            ScannerPacket.addOre(packet, HandlerOreData.mNameToIDMap.get(unName));
                            HandlerOreData.mIDToDisplayNameMap.put(HandlerOreData.mNameToIDMap.get(unName), tItem.func_82833_r());
                            continue;
                        }
                        if (!HandlerOreData.mUnlocalizedMap.containsKey(wildName)) continue;
                        packet.addBlock(c.func_76632_l().field_77276_a * 16 + x, y, c.func_76632_l().field_77275_b * 16 + z, HandlerOreData.mNameToIDMap.get(wildName));
                        ScannerPacket.addOre(packet, HandlerOreData.mNameToIDMap.get(wildName));
                        HandlerOreData.mIDToDisplayNameMap.put(HandlerOreData.mNameToIDMap.get(wildName), tItem.func_82833_r());
                    }
                }
            }
        }
    }

    private void runIEVeinScan(List<Chunk> area, World world, ScannerPacket packet) {
        for (Chunk c : area) {
            ExcavatorHandler.MineralMix vein = ExcavatorHandler.getRandomMineral((World)world, (int)c.field_76635_g, (int)c.field_76647_h);
            if (vein == null || !HandlerIEVein.veinToIDMap.containsKey(vein.name)) continue;
            for (int x = 1; x < 16; ++x) {
                for (int z = 1; z < 16; ++z) {
                    packet.addBlock(c.func_76632_l().field_77276_a * 16 + x, 255, c.func_76632_l().field_77275_b * 16 + z, HandlerIEVein.veinToIDMap.get(vein.name));
                    ScannerPacket.addOre(packet, HandlerIEVein.veinToIDMap.get(vein.name));
                }
            }
        }
    }

    private void runIPReservoirScan(List<Chunk> area, World world, ScannerPacket packet) {
        for (Chunk c : area) {
            PumpjackHandler.OilWorldInfo veinInfo = PumpjackHandler.getOilWorldInfo((World)world, (int)c.field_76635_g, (int)c.field_76647_h);
            PumpjackHandler.ReservoirType vein = veinInfo.getType();
            if (vein == null) continue;
            for (int x = 1; x < 16; ++x) {
                for (int z = 1; z < 16; ++z) {
                    packet.addBlock(c.func_76632_l().field_77276_a * 16 + x, 0, c.func_76632_l().field_77275_b * 16 + z, (short)HandlerOilVein.getFluidID(vein.getFluid()));
                    packet.addBlock(c.func_76632_l().field_77276_a * 16 + x, 1, c.func_76632_l().field_77275_b * 16 + z, (short)(veinInfo.current >> 16));
                    packet.addBlock(c.func_76632_l().field_77276_a * 16 + x, 2, c.func_76632_l().field_77275_b * 16 + z, (short)(veinInfo.current & 0xFFFF));
                    packet.addBlock(c.func_76632_l().field_77276_a * 16 + x, 3, c.func_76632_l().field_77275_b * 16 + z, (short)(vein.replenishRate >> 16));
                    packet.addBlock(c.func_76632_l().field_77276_a * 16 + x, 4, c.func_76632_l().field_77275_b * 16 + z, (short)(vein.replenishRate & 0xFFFF));
                    ScannerPacket.addOre(packet, (short)HandlerOilVein.getFluidID(vein.getFluid()));
                }
            }
        }
    }
}

